const express = require("express");
const path = require("path");
require("dotenv").config();

const app = express();
const PORT = process.env.PORT || 3000;

app.use(express.urlencoded({ extended: true }));
app.use(express.json());

app.set("view engine", "ejs");
app.set("views", path.join(__dirname, "views"));

const notesRoutes = require("./routes/notes");
app.use("/", notesRoutes);

app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
