const express = require("express");
const fs = require("fs");
const path = require("path");

const router = express.Router();
const dataFile = path.join(__dirname, "../data/notes.json");

router.get("/", (req, res) => {
  const notes = JSON.parse(fs.readFileSync(dataFile));
  res.render("index", { notes });
});

router.post("/add", (req, res) => {
  const notes = JSON.parse(fs.readFileSync(dataFile));
  notes.push(req.body.note);
  fs.writeFileSync(dataFile, JSON.stringify(notes, null, 2));
  res.redirect("/");
});

module.exports = router;
